//Listing 17.2. Projekt klasy wielokrotnego wykorzystania dla stosu przechowujcego obiekty klasy typu cakowitego
#include <iostream>
using namespace std;

typedef int Type;                   // przenona definicja typu

class Stack {
  Type *items;                      // stos przechowujcy symbole typu Type
  int top, size;                    // biecy wierzchoek stosu, cakowity rozmiar
  Stack(const Stack&);
  operator = (const Stack&);
public:
  Stack(int);                       // konstruktor konwertujcy
  void push(const Type&);           // umie na stosie
  Type pop();                       // zdejmij ze stosu
  bool isEmpty() const;             // czy stos jest pusty?
  ~Stack();                         // zwolnij pami na stercie
} ;

Stack::Stack(int sz = 100) : size(sz),top(0)
{ items = new Type[sz];             // przydziel pami na stercie
  if (items==0)
    { cout << "Brak pamici\n"; exit(1); } }

void Stack::push (const Type& c)   // przeka przez referencj
  { if (top < size)                // normalny przypadek: umie symbol
      items[top++] = c;
    else                           // obsu przepenienie stosu
     { Type *p = new Type[size*2]; // przydziel wicej pamici na stercie
       if (p == 0)                 // sprawd powodzenie
         { cout << "Brak pamici\n"; exit(1); }
       for (int i=0; i < size; i++) // skopiuj biec zawarto sterty
         p[i] = items[i];
       delete [] items;             // zwolnij pami na stercie
       items = p;                   // podcz nowy obszar pamici
       size *= 2;                   // uaktualnij nowy rozmiar stosu
       cout << "Nowy rozmiar: " << size << endl;
       items[top++] = c; } }        // umie symbol na stosie

Type Stack::pop()
{ return items[--top]; }            // bezwarunkowo zdejmij

bool Stack::isEmpty() const        // czy zostaa jeszcze warto do zdjcia?
{ return top == 0; }

Stack::~Stack()
{ delete [] items; }               // zwolnij pami na stercie

int main()
{
  Type data[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 } ;
  Stack s(4);                      // obiekt stosu
  int n = sizeof(data)/sizeof(Type); // liczba danych wejciowych
  cout << "Dane pocztkowe: ";
  for (int j = 0; j < n; j++)
    { cout << data[j] << " "; }    // wywietl dane pocztkowe
  cout << endl;
  for (int i = 0; i < n; i++)
   { s.push(data[i]); }            // umie dane na stosie
  cout << "Dane odwrcone: ";
  while (!s.isEmpty())             // zdejmuj ze stosu do czasu jego oprnienia
  cout << s.pop() << " ";
  cout << endl;
  return 0;
}
